/*******************************************************************************

Copyright (c) 2013, Perforce Software, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1.  Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

2.  Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL PERFORCE SOFTWARE, INC. BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

/*******************************************************************************
 * Name		: p4-map-api.cc
 *
 * Author	: dbb
 *
 * Description	: A "Flat C" interface for the MapApi object in the Perforce 
 *        API. Used to provide simple access for C#.NET using P/Invoke and 
 *		  dllimport.
 *
 ******************************************************************************/

#include "stdafx.h"

class P4MapApi;

/******************************************************************************
 * 'Flat' C interface for the dll. This interface will be imported into C# 
 *    using P/Invoke 
******************************************************************************/
enum MapType { MapInclude, MapExclude, MapOverlay };
enum MapDir  { MapLeftRight, MapRightLeft };

extern "C" 
{
    void * CreateMapApi();
    void DeleteMapApi( P4MapApi * pMap );
    void Clear( P4MapApi *pMap );
    int Count( P4MapApi *pMap );
    const char * GetLeft( P4MapApi *pMap, int i );
    const char * GetRight( P4MapApi *pMap, int i );
    int GetType( P4MapApi *pMap, int i );
    void Insert1( P4MapApi *pMap, const char * lr, int t );
    void Insert2( P4MapApi *pMap, const char * l, 
                                       const char * r, int t );
    void * Join1( P4MapApi *pLeft, P4MapApi *pRight );
    void * Join2( P4MapApi *pLeft, int ld,
                                       P4MapApi *pRight, int rd );
    const char * Translate( P4MapApi *pMap, const char * p,
                                                    MapDir d);
    void DeletePtr( const void * p );
}